/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.routing;

import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.ScxHttpServerResponse;
import cool.scx.http.exception.MethodNotAllowedException;
import cool.scx.http.exception.NotFoundException;
import cool.scx.http.exception.ScxHttpException;
import cool.scx.http.parameters.Parameters;
import cool.scx.http.routing.PathMatcher;
import cool.scx.http.routing.Route;
import cool.scx.http.routing.RouterImpl;
import cool.scx.http.routing.RoutingContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RoutingContextImpl
implements RoutingContext {
    private final RouterImpl router;
    private final ScxHttpServerRequest request;
    private final Iterator<Route> iter;
    private final Map<String, Object> data;
    private Parameters<String, String> nowPathParams;

    RoutingContextImpl(RouterImpl router, ScxHttpServerRequest request) {
        this.router = router;
        this.request = request;
        this.iter = router.routes.iterator();
        this.data = new HashMap<String, Object>();
    }

    @Override
    public <T extends ScxHttpServerRequest> T request() {
        return (T)this.request;
    }

    @Override
    public <T extends ScxHttpServerResponse> T response() {
        return (T)this.request.response();
    }

    @Override
    public void next() {
        ScxHttpException e = new NotFoundException();
        while (this.iter.hasNext()) {
            Route route = this.iter.next();
            boolean typeMatcherResult = route.typeMatcher().matches(this.request);
            if (!typeMatcherResult) continue;
            PathMatcher.MatchResult pathMatchResult = route.pathMatcher().matches(this.request.path());
            this.nowPathParams = pathMatchResult.pathParams();
            if (!pathMatchResult.accepted()) continue;
            boolean methodMatchResult = route.methodMatcher().matches(this.request.method());
            if (!methodMatchResult) {
                e = new MethodNotAllowedException();
                continue;
            }
            route.handler().accept(this);
            return;
        }
        throw e;
    }

    @Override
    public Parameters<String, String> pathParams() {
        return this.nowPathParams;
    }

    @Override
    public <T> Map<String, T> data() {
        return this.data;
    }
}

