/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http;

import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.headers.ScxHttpHeaderName;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.headers.cookie.Cookie;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.byte_array.ByteArrayWriter;
import cool.scx.http.media.empty.EmptyWriter;
import cool.scx.http.media.event_stream.ServerEventStream;
import cool.scx.http.media.event_stream.ServerEventStreamWriter;
import cool.scx.http.media.form_params.FormParams;
import cool.scx.http.media.form_params.FormParamsWriter;
import cool.scx.http.media.input_stream.InputStreamWriter;
import cool.scx.http.media.json_node.JsonNodeWriter;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartWriter;
import cool.scx.http.media.object.ObjectWriter;
import cool.scx.http.media.path.PathWriter;
import cool.scx.http.media.string.StringWriter;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.http.status.ScxHttpStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Path;

public interface ScxHttpServerResponse {
    public ScxHttpServerRequest request();

    public ScxHttpStatus status();

    public ScxHttpHeadersWritable headers();

    public ScxHttpServerResponse status(ScxHttpStatus var1);

    public OutputStream outputStream(long var1);

    public boolean isSent();

    default public OutputStream outputStream() {
        return this.outputStream(-1L);
    }

    default public void send(MediaWriter writer) {
        long expectedLength = writer.beforeWrite(this.headers(), this.request().headers());
        try {
            writer.write(this.outputStream(expectedLength));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    default public void send() {
        this.send(EmptyWriter.EMPTY_WRITER);
    }

    default public void send(byte[] bytes) {
        this.send(new ByteArrayWriter(bytes));
    }

    default public void send(String str) {
        this.send(new StringWriter(str));
    }

    default public void send(String str, Charset charset) {
        this.send(new StringWriter(str, charset));
    }

    default public void send(Path path) {
        this.send(new PathWriter(path));
    }

    default public void send(Path path, long offset, long length) {
        this.send(new PathWriter(path, offset, length));
    }

    default public void send(InputStream inputStream) {
        this.send(new InputStreamWriter(inputStream));
    }

    default public void send(FormParams formParams) {
        this.send(new FormParamsWriter(formParams));
    }

    default public void send(MultiPart multiPart) {
        this.send(new MultiPartWriter(multiPart));
    }

    default public void send(JsonNode jsonNode) {
        this.send(new JsonNodeWriter(jsonNode));
    }

    default public void send(Object object) {
        this.send(new ObjectWriter(object));
    }

    default public ServerEventStream sendEventStream() {
        ServerEventStreamWriter writer = new ServerEventStreamWriter();
        this.send(writer);
        return writer.eventStream();
    }

    default public ScxHttpServerResponse status(int code) {
        return this.status(ScxHttpStatus.of(code));
    }

    default public ScxHttpServerResponse setHeader(ScxHttpHeaderName headerName, String ... values) {
        this.headers().set(headerName, values);
        return this;
    }

    default public ScxHttpServerResponse addHeader(ScxHttpHeaderName headerName, String ... values) {
        this.headers().add(headerName, values);
        return this;
    }

    default public ScxHttpServerResponse setHeader(String headerName, String ... values) {
        this.headers().set(headerName, values);
        return this;
    }

    default public ScxHttpServerResponse addHeader(String headerName, String ... values) {
        this.headers().add(headerName, values);
        return this;
    }

    default public ScxHttpServerResponse addSetCookie(Cookie ... cookie) {
        this.headers().addSetCookie(cookie);
        return this;
    }

    default public ScxHttpServerResponse removeSetCookie(String name) {
        this.headers().removeSetCookie(name);
        return this;
    }

    default public ScxMediaType contentType() {
        return this.headers().contentType();
    }

    default public ScxHttpServerResponse contentType(ScxMediaType contentType) {
        this.headers().contentType(contentType);
        return this;
    }

    default public Long contentLength() {
        return this.headers().contentLength();
    }

    default public ScxHttpServerResponse contentLength(long contentLength) {
        this.headers().contentLength(contentLength);
        return this;
    }
}

