/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.headers;

import cool.scx.http.headers.HttpFieldName;
import cool.scx.http.headers.ScxHttpHeaderName;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.content_disposition.ContentDisposition;
import cool.scx.http.headers.cookie.Cookie;
import cool.scx.http.headers.cookie.Cookies;
import cool.scx.http.headers.cookie.CookiesWritable;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.http.parameters.ParametersWritable;

public interface ScxHttpHeadersWritable
extends ScxHttpHeaders,
ParametersWritable<ScxHttpHeaderName, String> {
    default public ScxHttpHeadersWritable set(String name, String ... value) {
        this.set(ScxHttpHeaderName.of(name), value);
        return this;
    }

    default public ScxHttpHeadersWritable add(String name, String ... value) {
        this.add(ScxHttpHeaderName.of(name), value);
        return this;
    }

    default public ScxHttpHeadersWritable remove(String name) {
        this.remove(ScxHttpHeaderName.of(name));
        return this;
    }

    default public ScxHttpHeadersWritable cookies(Cookies cookies) {
        this.set(HttpFieldName.COOKIE, cookies.encodeCookie());
        return this;
    }

    default public ScxHttpHeadersWritable setCookies(Cookies cookies) {
        this.set(HttpFieldName.SET_COOKIE, cookies.encodeSetCookie());
        return this;
    }

    default public ScxHttpHeadersWritable contentType(ScxMediaType mediaType) {
        this.set(HttpFieldName.CONTENT_TYPE, mediaType.encode());
        return this;
    }

    default public ScxHttpHeadersWritable contentDisposition(ContentDisposition contentDisposition) {
        this.set(HttpFieldName.CONTENT_DISPOSITION, contentDisposition.encode());
        return this;
    }

    default public ScxHttpHeadersWritable addCookie(Cookie ... cookie) {
        CookiesWritable newCookies = (CookiesWritable)this.cookies();
        for (Cookie c : cookie) {
            newCookies.add(c);
        }
        return this.cookies(newCookies);
    }

    default public ScxHttpHeadersWritable removeCookie(String name) {
        CookiesWritable newCookies = (CookiesWritable)this.cookies();
        newCookies.remove(name);
        return this.cookies(newCookies);
    }

    default public ScxHttpHeadersWritable addSetCookie(Cookie ... cookie) {
        CookiesWritable newSetCookies = (CookiesWritable)this.setCookies();
        for (Cookie c : cookie) {
            newSetCookies.add(c);
        }
        return this.setCookies(newSetCookies);
    }

    default public ScxHttpHeadersWritable removeSetCookie(String name) {
        CookiesWritable newSetCookies = (CookiesWritable)this.setCookies();
        newSetCookies.remove(name);
        return this.cookies(newSetCookies);
    }

    default public ScxHttpHeadersWritable contentLength(long contentLength) {
        this.set(HttpFieldName.CONTENT_LENGTH, String.valueOf(contentLength));
        return this;
    }
}

