/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.form_params;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.form_params.FormParams;
import cool.scx.http.media.form_params.FormParamsHelper;
import cool.scx.http.media_type.MediaType;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class FormParamsWriter
implements MediaWriter {
    private final FormParams formParams;
    private byte[] bytes;

    public FormParamsWriter(FormParams formParams) {
        this.formParams = formParams;
    }

    @Override
    public long beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        if (responseHeaders.contentType() == null) {
            responseHeaders.contentType(MediaType.APPLICATION_X_WWW_FORM_URLENCODED);
        }
        this.bytes = FormParamsHelper.encodeFormParams(this.formParams).getBytes(StandardCharsets.UTF_8);
        return this.bytes.length;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        try (OutputStream outputStream2 = outputStream;){
            outputStream.write(this.bytes);
        }
    }
}

