/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.version;

public enum HttpVersion {
    HTTP_1_1("HTTP/1.1"),
    HTTP_2("HTTP/2"),
    HTTP_3("HTTP/3");

    private final String value;

    private HttpVersion(String value) {
        this.value = value;
    }

    public static HttpVersion of(String version) {
        HttpVersion h = HttpVersion.find(version);
        if (h == null) {
            throw new IllegalArgumentException("Unsupported HTTP version: " + version);
        }
        return h;
    }

    public static HttpVersion find(String version) {
        String upperCase;
        return switch (upperCase = version.toUpperCase()) {
            case "HTTP/1.1" -> HTTP_1_1;
            case "HTTP/2" -> HTTP_2;
            case "HTTP/3" -> HTTP_3;
            default -> null;
        };
    }

    public String value() {
        return this.value;
    }
}

