/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.headers;

import cool.scx.http.headers.ScxHttpHeaderName;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import java.util.List;
import java.util.Map;

public final class ScxHttpHeadersHelper {
    public static <T extends ScxHttpHeadersWritable> T parseHeaders(T headers, String headersStr) {
        int length = headersStr.length();
        int start = 0;
        while (start < length) {
            int colonIndex;
            int end = headersStr.indexOf("\r\n", start);
            if (end == -1) {
                end = length;
            }
            if ((colonIndex = headersStr.indexOf(58, start, end)) != -1) {
                String key = headersStr.substring(start, colonIndex).trim();
                String value = headersStr.substring(colonIndex + 1, end).trim();
                headers.add(key, value);
            }
            start = end + 2;
        }
        return headers;
    }

    public static String encodeHeaders(ScxHttpHeaders headers) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry header : headers) {
            ScxHttpHeaderName key = (ScxHttpHeaderName)header.getKey();
            List values = (List)header.getValue();
            for (String value : values) {
                sb.append(key.value()).append(": ").append(value).append("\r\n");
            }
        }
        return sb.toString();
    }
}

