/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media_type;

import cool.scx.http.media_type.IllegalMediaTypeException;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.http.media_type.ScxMediaTypeImpl;
import cool.scx.http.media_type.ScxMediaTypeWritable;
import cool.scx.http.parameters.Parameters;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ScxMediaTypeHelper {
    public static final Pattern SEMICOLON_PATTERN = Pattern.compile(";\\s*");

    public static ScxMediaTypeWritable decodedMediaType(String str) throws IllegalMediaTypeException {
        String[] parts = SEMICOLON_PATTERN.split(str);
        if (parts.length == 0) {
            throw new IllegalMediaTypeException(str);
        }
        String mediaTypeStr = parts[0];
        String[] split = mediaTypeStr.split("/");
        if (split.length != 2) {
            throw new IllegalMediaTypeException(str);
        }
        ScxMediaTypeImpl m = new ScxMediaTypeImpl();
        m.type(split[0]);
        m.subtype(split[1]);
        for (int i = 1; i < parts.length; ++i) {
            String[] s = parts[i].split("=", 2);
            if (s.length != 2) continue;
            m.params().add(s[0], s[1]);
        }
        return m;
    }

    public static String encodeMediaType(ScxMediaType mediaType) {
        String type = mediaType.type();
        String subtype = mediaType.subtype();
        Parameters<String, String> params = mediaType.params();
        StringBuilder sb = new StringBuilder().append(type).append('/').append(subtype);
        if (params != null) {
            ScxMediaTypeHelper.encodeParams(sb, params);
        }
        return sb.toString();
    }

    public static void encodeParams(StringBuilder result, Parameters<String, String> params) {
        for (Map.Entry entry : params) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            for (String value : values) {
                result.append("; ").append(key).append("=").append(value);
            }
        }
    }
}

