/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.headers.accept;

import cool.scx.http.headers.accept.AcceptImpl;
import cool.scx.http.headers.accept.AcceptWritable;
import cool.scx.http.headers.accept.IllegalMediaRangeException;
import cool.scx.http.headers.accept.MediaRange;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AcceptHelper {
    public static AcceptWritable decodeAccepts(String s) throws IllegalMediaRangeException {
        String[] mediaTypes;
        ArrayList<MediaRange> list = new ArrayList<MediaRange>();
        for (String mediaType : mediaTypes = s.split(",")) {
            list.add(MediaRange.of(mediaType));
        }
        List<MediaRange> sorted = AcceptHelper.sortMediaRanges(list);
        return new AcceptImpl(sorted);
    }

    public static List<MediaRange> sortMediaRanges(List<MediaRange> ranges) {
        return ranges.stream().sorted((a, b) -> {
            int qCompare = Double.compare(b.q(), a.q());
            if (qCompare != 0) {
                return qCompare;
            }
            int typeCompare = Boolean.compare(!a.type().equals("*"), !b.type().equals("*"));
            if (typeCompare != 0) {
                return -typeCompare;
            }
            int subtypeCompare = Boolean.compare(!a.subtype().equals("*"), !b.subtype().equals("*"));
            return -subtypeCompare;
        }).collect(Collectors.toList());
    }
}

