/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.uri;

import cool.scx.http.parameters.Parameters;
import cool.scx.http.parameters.ParametersWritable;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.uri.ScxURIHelper;

public interface ScxURIWritable
extends ScxURI {
    public ParametersWritable<String, String> query();

    public ScxURIWritable scheme(String var1);

    public ScxURIWritable host(String var1);

    public ScxURIWritable port(Integer var1);

    public ScxURIWritable path(String var1);

    public ScxURIWritable query(Parameters<String, String> var1);

    public ScxURIWritable fragment(String var1);

    default public ScxURIWritable query(String queryString) {
        return this.query(ScxURIHelper.decodeQuery(queryString));
    }

    default public ScxURIWritable setQuery(String name, String ... value) {
        this.query().set(name, value);
        return this;
    }

    default public ScxURIWritable addQuery(String name, String ... value) {
        this.query().add(name, value);
        return this;
    }

    default public ScxURIWritable addQuery(String name, Object ... value) {
        String[] strArray = new String[value.length];
        for (int i = 0; i < value.length; ++i) {
            strArray[i] = value[i].toString();
        }
        this.query().add(name, strArray);
        return this;
    }

    default public ScxURIWritable removeQuery(String name) {
        this.query().remove(name);
        return this;
    }

    default public ScxURIWritable clearQuery() {
        this.query().clear();
        return this;
    }
}

