/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.event_stream;

import cool.scx.http.media.event_stream.EventStreamHelper;
import cool.scx.http.media.event_stream.SseEvent;
import cool.scx.http.media.event_stream.SseEventWritable;
import cool.scx.io.IOHelper;
import cool.scx.io.data_reader.LinkedDataReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.function.Consumer;

public class ClientEventStream {
    private final LinkedDataReader dataReader;
    private final Charset charset;
    private Consumer<SseEvent> eventHandler;
    private boolean running;

    public ClientEventStream(InputStream in, Charset charset) {
        this.dataReader = IOHelper.inputStreamToDataReader((InputStream)in);
        this.charset = charset;
        this.running = true;
    }

    public void onEvent(Consumer<SseEvent> eventHandler) {
        this.eventHandler = eventHandler;
    }

    public SseEvent readEvent() throws IOException {
        SseEventWritable event = SseEvent.of();
        byte[] bytes;
        String line;
        while (!(line = new String(bytes = this.dataReader.readUntil(EventStreamHelper.LF_BYTES), this.charset)).isEmpty()) {
            if (line.startsWith("event: ")) {
                event.event(line.substring(7).trim());
                continue;
            }
            if (line.startsWith("data: ")) {
                event.data(line.substring(6).trim());
                continue;
            }
            if (line.startsWith("id: ")) {
                event.id(line.substring(4).trim());
                continue;
            }
            if (line.startsWith("retry: ")) {
                try {
                    event.retry(Long.parseLong(line.substring(7).trim()));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!line.startsWith(": ")) continue;
            event.comment(line.substring(2).trim());
        }
        return event;
    }

    public void start() {
        while (this.running) {
            try {
                SseEvent event = this.readEvent();
                this.callEventHandler(event);
            }
            catch (IOException e) {
                break;
            }
        }
    }

    public void callEventHandler(SseEvent sseEvent) {
        if (this.eventHandler != null) {
            this.eventHandler.accept(sseEvent);
        }
    }

    public void stop() {
        this.running = false;
    }
}

