/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.multi_part;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartStreamCached;
import cool.scx.http.media.multi_part.MultiPartStreamReader;
import java.io.InputStream;
import java.nio.file.Path;

public class MultiPartStreamCachedReader
implements MediaReader<MultiPart> {
    public static final MultiPartStreamCachedReader MULTI_PART_READER_CACHED = new MultiPartStreamCachedReader();
    private final Path cachePath;

    public MultiPartStreamCachedReader(Path cachePath) {
        this.cachePath = cachePath;
    }

    private MultiPartStreamCachedReader() {
        this.cachePath = Path.of(System.getProperty("java.io.tmpdir"), new String[0]).resolve(".SCX-CACHE");
    }

    @Override
    public MultiPart read(InputStream inputStream, ScxHttpHeaders headers) {
        String boundary = MultiPartStreamReader.checkedBoundary(headers);
        return new MultiPartStreamCached(inputStream, boundary, this.cachePath);
    }
}

