/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.headers.accept;

import cool.scx.http.headers.accept.IllegalMediaRangeException;
import cool.scx.http.headers.accept.MediaRangeImpl;
import cool.scx.http.headers.accept.MediaRangeWritable;
import cool.scx.http.media_type.ScxMediaTypeHelper;

public class MediaRangeHelper {
    public static MediaRangeWritable parseMediaRange(String mediaRangeStr) throws IllegalMediaRangeException {
        String[] parts = ScxMediaTypeHelper.SEMICOLON_PATTERN.split(mediaRangeStr);
        if (parts.length == 0) {
            throw new IllegalMediaRangeException("Invalid media range: " + mediaRangeStr);
        }
        String mediaTypeStr = parts[0];
        String[] split = mediaTypeStr.split("/");
        if (split.length != 2) {
            throw new IllegalMediaRangeException("Invalid media type: " + mediaRangeStr);
        }
        MediaRangeImpl m = new MediaRangeImpl();
        m.type(split[0]);
        m.subtype(split[1]);
        for (int i = 1; i < parts.length; ++i) {
            String[] s = parts[i].split("=", 2);
            if (s.length != 2) continue;
            m.params().add(s[0], s[1]);
        }
        return m;
    }
}

