/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.parameters;

import cool.scx.common.multi_map.MultiMap;
import cool.scx.http.parameters.Parameters;
import cool.scx.http.parameters.ParametersWritable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParametersImpl<K, V>
implements ParametersWritable<K, V> {
    private final MultiMap<K, V> map = new MultiMap(LinkedHashMap::new, ArrayList::new);

    public ParametersImpl(Parameters<K, V> p) {
        this();
        for (Map.Entry entry : p) {
            this.map.set(entry.getKey(), (Collection)entry.getValue());
        }
    }

    public ParametersImpl() {
    }

    @Override
    public ParametersImpl<K, V> set(K name, V ... value) {
        this.map.set(name, (Object[])value);
        return this;
    }

    @Override
    public ParametersImpl<K, V> add(K name, V ... value) {
        this.map.add(name, (Object[])value);
        return this;
    }

    @Override
    public ParametersImpl<K, V> remove(K name) {
        this.map.removeAll(name);
        return this;
    }

    @Override
    public ParametersWritable<K, V> clear() {
        this.map.clear();
        return this;
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public Set<K> names() {
        return this.map.keys();
    }

    @Override
    public V get(K name) {
        return (V)this.map.get(name);
    }

    @Override
    public List<V> getAll(K name) {
        return this.map.getAll(name);
    }

    @Override
    public Iterator<Map.Entry<K, List<V>>> iterator() {
        return this.map.iterator();
    }

    @Override
    public Map<K, List<V>> toMap() {
        return this.map.toMultiValueMap();
    }

    public String toString() {
        return this.map.toString();
    }
}

