/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.uri;

import cool.scx.http.parameters.Parameters;
import cool.scx.http.parameters.ParametersWritable;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.uri.URIEncoder;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ScxURIHelper {
    public static ParametersWritable<String, String> decodeQuery(String value) {
        String[] split;
        ParametersWritable<String, String> query = Parameters.of();
        if (value == null) {
            return query;
        }
        for (String s : split = value.split("&")) {
            split = s.split("=", 2);
            if (split.length != 2) continue;
            query.add(split[0], (String[])new String[]{split[1]});
        }
        return query;
    }

    public static String encodeQuery(Parameters<String, String> query, boolean uriEncoding) {
        ArrayList<CallSite> l = new ArrayList<CallSite>();
        for (Map.Entry entry : query) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            for (String s : value) {
                if (uriEncoding) {
                    String kk = URIEncoder.encodeURIComponent(key);
                    String vv = URIEncoder.encodeURIComponent(s);
                    l.add((CallSite)((Object)(kk + "=" + vv)));
                    continue;
                }
                l.add((CallSite)((Object)(key + "=" + s)));
            }
        }
        return String.join((CharSequence)"&", l);
    }

    public static String encodeScxURI(ScxURI uri, boolean uriEncoding) {
        String scheme = uri.scheme();
        String host = uri.host();
        Integer port = uri.port();
        String path = uri.path();
        Parameters<String, String> query = uri.query();
        String fragment = uri.fragment();
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            sb.append(scheme);
            sb.append(':');
        }
        if (host != null) {
            sb.append("//");
            sb.append(host);
            if (port != null) {
                sb.append(':');
                sb.append(port);
            }
        }
        if (path != null) {
            if (uriEncoding) {
                sb.append(URIEncoder.encodeURI(path));
            } else {
                sb.append(path);
            }
        }
        if (query != null && !query.isEmpty()) {
            sb.append('?');
            sb.append(ScxURIHelper.encodeQuery(query, uriEncoding));
        }
        if (fragment != null) {
            sb.append('#');
            if (uriEncoding) {
                sb.append(URIEncoder.encodeURI(fragment));
            } else {
                sb.append(fragment);
            }
        }
        return sb.toString();
    }
}

