/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.gzip;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.headers.content_encoding.ContentEncoding;
import cool.scx.http.media.MediaWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class GzipWriter
implements MediaWriter {
    private final MediaWriter mediaWriter;

    public GzipWriter(MediaWriter mediaWriter) {
        this.mediaWriter = mediaWriter;
    }

    @Override
    public long beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        responseHeaders.contentEncoding(ContentEncoding.GZIP);
        this.mediaWriter.beforeWrite(responseHeaders, requestHeaders);
        return -1L;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
        this.mediaWriter.write(gzipOutputStream);
    }
}

