/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media.byte_array.ByteArrayReader;
import cool.scx.http.media.cache.CacheBody;
import cool.scx.http.media.cache.CacheBodyReader;
import cool.scx.http.media.event_stream.ClientEventStream;
import cool.scx.http.media.event_stream.ClientEventStreamReader;
import cool.scx.http.media.form_params.FormParams;
import cool.scx.http.media.form_params.FormParamsReader;
import cool.scx.http.media.gzip.GzipBody;
import cool.scx.http.media.gzip.GzipBodyReader;
import cool.scx.http.media.json_node.JsonNodeReader;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartStreamCachedReader;
import cool.scx.http.media.multi_part.MultiPartStreamReader;
import cool.scx.http.media.object.ObjectReader;
import cool.scx.http.media.path.PathReader;
import cool.scx.http.media.string.StringReader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public interface ScxHttpBody {
    public InputStream inputStream();

    public <T> T as(MediaReader<T> var1);

    default public byte[] asBytes() {
        return this.as(ByteArrayReader.BYTE_ARRAY_READER);
    }

    default public String asString() {
        return this.as(StringReader.STRING_READER);
    }

    default public String asString(Charset charset) {
        return this.as(new StringReader(charset));
    }

    default public FormParams asFormParams() {
        return this.as(FormParamsReader.FORM_PARAMS_READER);
    }

    default public MultiPart asMultiPart() {
        return this.as(MultiPartStreamReader.MULTI_PART_READER);
    }

    default public MultiPart asMultiPartCached() {
        return this.as(MultiPartStreamCachedReader.MULTI_PART_READER_CACHED);
    }

    default public MultiPart asMultiPartCached(Path cachePath) {
        return this.as(new MultiPartStreamCachedReader(cachePath));
    }

    default public Path asPath(Path path, OpenOption ... options) {
        return this.as(new PathReader(path, options));
    }

    default public JsonNode asJsonNode() {
        return this.as(JsonNodeReader.JSON_NODE_READER);
    }

    default public <T> T asObject(Class<T> c) {
        return this.as(new ObjectReader<T>(c));
    }

    default public <T> T asObject(TypeReference<T> c) {
        return this.as(new ObjectReader<T>(c));
    }

    default public ClientEventStream asEventStream() {
        return this.as(ClientEventStreamReader.CLIENT_EVENT_STREAM_READER);
    }

    default public GzipBody asGzipBody() {
        return this.as(GzipBodyReader.GZIP_BODY_READER);
    }

    default public CacheBody asCacheBody() {
        return this.as(CacheBodyReader.CACHE_BODY_READER);
    }
}

