/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.gzip;

import cool.scx.http.ScxHttpBody;
import cool.scx.http.exception.UnsupportedMediaTypeException;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.content_encoding.ContentEncoding;
import cool.scx.http.headers.content_encoding.ScxContentEncoding;
import cool.scx.http.media.MediaReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.zip.GZIPInputStream;

public class GzipBody
implements ScxHttpBody {
    private final ScxHttpHeaders headers;
    private final InputStream inputStream;

    public GzipBody(InputStream inputStream, ScxHttpHeaders requestHeaders) {
        this.headers = requestHeaders;
        this.inputStream = GzipBody.initInputStream(inputStream, this.headers.contentEncoding());
    }

    public static InputStream initInputStream(InputStream inputStream, ScxContentEncoding contentEncoding) {
        if (inputStream instanceof GZIPInputStream) {
            return inputStream;
        }
        if (contentEncoding == null) {
            return inputStream;
        }
        if (contentEncoding == ContentEncoding.GZIP) {
            try {
                return new GZIPInputStream(inputStream);
            }
            catch (IOException e) {
                throw new UnsupportedMediaTypeException(e);
            }
        }
        throw new UnsupportedMediaTypeException("Unsupported Content-Encoding: " + String.valueOf(contentEncoding));
    }

    @Override
    public InputStream inputStream() {
        return this.inputStream;
    }

    @Override
    public <T> T as(MediaReader<T> t) {
        try {
            return t.read(this.inputStream, this.headers);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

