/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.multi_part;

import cool.scx.http.exception.BadRequestException;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartStream;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import java.io.InputStream;

public class MultiPartStreamReader
implements MediaReader<MultiPart> {
    public static final MultiPartStreamReader MULTI_PART_READER = new MultiPartStreamReader();

    private MultiPartStreamReader() {
    }

    public static String checkedBoundary(ScxHttpHeaders headers) {
        ScxMediaType contentType = headers.contentType();
        if (contentType == null) {
            throw new IllegalArgumentException("No Content-Type header found");
        }
        if (!MediaType.MULTIPART_FORM_DATA.equalsIgnoreParams(contentType)) {
            throw new IllegalArgumentException("Content-Type is not multipart/form-data");
        }
        String boundary = contentType.boundary();
        if (boundary == null) {
            throw new BadRequestException("No boundary found");
        }
        return boundary;
    }

    @Override
    public MultiPart read(InputStream inputStream, ScxHttpHeaders headers) {
        String boundary = MultiPartStreamReader.checkedBoundary(headers);
        return new MultiPartStream(inputStream, boundary);
    }
}

