/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.headers;

import cool.scx.http.headers.ScxHttpHeaderName;
import cool.scx.http.headers.ScxHttpHeadersReadHelper;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.headers.content_encoding.ScxContentEncoding;
import cool.scx.http.headers.cookie.Cookie;
import cool.scx.http.media_type.ScxMediaType;

public interface ScxHttpHeadersWriteHelper<T extends ScxHttpHeadersWriteHelper<T>>
extends ScxHttpHeadersReadHelper {
    @Override
    public ScxHttpHeadersWritable headers();

    default public T setHeader(ScxHttpHeaderName headerName, String ... values) {
        this.headers().set(headerName, values);
        return (T)this;
    }

    default public T addHeader(ScxHttpHeaderName headerName, String ... values) {
        this.headers().add(headerName, values);
        return (T)this;
    }

    default public T setHeader(String headerName, String ... values) {
        this.headers().set(headerName, values);
        return (T)this;
    }

    default public T addHeader(String headerName, String ... values) {
        this.headers().add(headerName, values);
        return (T)this;
    }

    default public T contentType(ScxMediaType contentType) {
        this.headers().contentType(contentType);
        return (T)this;
    }

    default public T contentLength(long contentLength) {
        this.headers().contentLength(contentLength);
        return (T)this;
    }

    default public T contentEncoding(ScxContentEncoding contentEncoding) {
        this.headers().contentEncoding(contentEncoding);
        return (T)this;
    }

    default public T addCookie(Cookie ... cookie) {
        this.headers().addCookie(cookie);
        return (T)this;
    }

    default public T removeCookie(String name) {
        this.headers().removeCookie(name);
        return (T)this;
    }

    default public T addSetCookie(Cookie ... cookie) {
        this.headers().addSetCookie(cookie);
        return (T)this;
    }

    default public T removeSetCookie(String name) {
        this.headers().removeSetCookie(name);
        return (T)this;
    }
}

