/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.headers;

import cool.scx.http.headers.ScxHttpHeaderName;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import java.util.List;
import java.util.Map;

public final class ScxHttpHeadersHelper {
    public static <T extends ScxHttpHeadersWritable> T parseHeaders(T headers, String headersStr, boolean strictMode) {
        int length = headersStr.length();
        int start = 0;
        while (start < length) {
            int colonIndex;
            int end;
            int n = end = strictMode ? headersStr.indexOf("\r\n", start) : headersStr.indexOf(10, start);
            if (end == -1) {
                end = length;
            }
            if ((colonIndex = headersStr.indexOf(58, start, end)) != -1) {
                int keyStart;
                int keyEnd = colonIndex;
                int valueStart = colonIndex + 1;
                int valueEnd = end;
                for (keyStart = start; keyStart < keyEnd && ScxHttpHeadersHelper.isWhitespace(headersStr.charAt(keyStart)); ++keyStart) {
                }
                while (keyEnd > keyStart && ScxHttpHeadersHelper.isWhitespace(headersStr.charAt(keyEnd - 1))) {
                    --keyEnd;
                }
                while (valueStart < valueEnd && ScxHttpHeadersHelper.isWhitespace(headersStr.charAt(valueStart))) {
                    ++valueStart;
                }
                if (!strictMode && headersStr.charAt(valueEnd - 1) == '\r') {
                    --valueEnd;
                }
                while (valueEnd > valueStart && ScxHttpHeadersHelper.isWhitespace(headersStr.charAt(valueEnd - 1))) {
                    --valueEnd;
                }
                String key = headersStr.substring(keyStart, keyEnd);
                String value = headersStr.substring(valueStart, valueEnd);
                headers.add(key, value);
            }
            start = strictMode ? end + 2 : end + 1;
        }
        return headers;
    }

    public static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    public static String encodeHeaders(ScxHttpHeaders headers) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry header : headers) {
            ScxHttpHeaderName key = (ScxHttpHeaderName)header.getKey();
            List values = (List)header.getValue();
            for (String value : values) {
                sb.append(key.value()).append(": ").append(value).append("\r\n");
            }
        }
        return sb.toString();
    }
}

