/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.object;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import cool.scx.common.util.ObjectUtils;
import cool.scx.http.exception.BadRequestException;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media.string.StringReader;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import java.io.IOException;
import java.io.InputStream;

public class ObjectReader<T>
implements MediaReader<T> {
    private final JavaType type;

    public ObjectReader(Class<T> clazz) {
        this.type = ObjectUtils.constructType(clazz);
    }

    public ObjectReader(TypeReference<T> clazz) {
        this.type = ObjectUtils.constructType(clazz);
    }

    public ObjectReader(JavaType clazz) {
        this.type = clazz;
    }

    @Override
    public T read(InputStream inputStream, ScxHttpHeaders requestHeaders) throws IOException {
        String str = StringReader.STRING_READER.read(inputStream, requestHeaders);
        ScxMediaType contentType = requestHeaders.contentType();
        if (MediaType.APPLICATION_JSON.equalsIgnoreParams(contentType)) {
            try {
                return (T)ObjectUtils.jsonMapper().readValue(str, this.type);
            }
            catch (JsonProcessingException e) {
                throw new BadRequestException("JSON \u683c\u5f0f\u4e0d\u6b63\u786e !!!", (Throwable)e);
            }
        }
        if (MediaType.APPLICATION_XML.equalsIgnoreParams(contentType)) {
            try {
                return (T)ObjectUtils.xmlMapper().readValue(str, this.type);
            }
            catch (JsonProcessingException e) {
                throw new BadRequestException("XML \u683c\u5f0f\u4e0d\u6b63\u786e !!!", (Throwable)e);
            }
        }
        try {
            return (T)ObjectUtils.jsonMapper().readValue(str, this.type);
        }
        catch (Exception exception) {
            try {
                return (T)ObjectUtils.xmlMapper().readValue(str, this.type);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u8f6c\u6362\u4e3a " + String.valueOf(this.type) + " !!! : " + str);
            }
        }
    }
}

