/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.version;

public enum HttpVersion {
    HTTP_1_1("HTTP/1.1", "http/1.1"),
    HTTP_2("HTTP/2", "h2"),
    HTTP_3("HTTP/3", "h3");

    private final String protocolVersion;
    private final String alpnValue;

    private HttpVersion(String protocolVersion, String alpnValue) {
        this.protocolVersion = protocolVersion;
        this.alpnValue = alpnValue;
    }

    public static HttpVersion of(String version) {
        HttpVersion h = HttpVersion.find(version);
        if (h == null) {
            throw new IllegalArgumentException("Unsupported HTTP version: " + version);
        }
        return h;
    }

    public static HttpVersion find(String version) {
        String lowerCase;
        return switch (lowerCase = version.toLowerCase()) {
            case "http/1.1" -> HTTP_1_1;
            case "http/2", "h2" -> HTTP_2;
            case "http/3", "h3" -> HTTP_3;
            default -> null;
        };
    }

    public String protocolVersion() {
        return this.protocolVersion;
    }

    public String alpnValue() {
        return this.alpnValue;
    }

    public String toString() {
        return this.protocolVersion;
    }
}

