/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.string;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StringWriter
implements MediaWriter {
    private final Charset charset;
    private final String str;
    private byte[] bytes;

    public StringWriter(String str) {
        this(str, StandardCharsets.UTF_8);
    }

    public StringWriter(String str, Charset charset) {
        this.str = str;
        this.charset = charset;
        this.bytes = null;
    }

    @Override
    public long beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        if (responseHeaders.contentType() == null) {
            responseHeaders.contentType(ScxMediaType.of(MediaType.TEXT_PLAIN).charset(this.charset));
        }
        this.bytes = this.str.getBytes(this.charset);
        return this.bytes.length;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        try (OutputStream outputStream2 = outputStream;){
            outputStream.write(this.bytes);
        }
    }
}

