/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.routing.handler;

import cool.scx.http.exception.NotFoundException;
import cool.scx.http.headers.HttpFieldName;
import cool.scx.http.headers.range.Range;
import cool.scx.http.media_type.FileFormat;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.http.media_type.ScxMediaTypeWritable;
import cool.scx.http.routing.RoutingContext;
import cool.scx.http.status.HttpStatus;
import cool.scx.io.IOHelper;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

public class StaticHelper {
    public static void sendStatic(Path path, RoutingContext context) {
        Object request = context.request();
        Object response = context.response();
        boolean notExists = Files.notExists(path, new LinkOption[0]);
        if (notExists) {
            throw new NotFoundException();
        }
        long fileLength = IOHelper.getFileSize((Path)path);
        response.headers().set(HttpFieldName.ACCEPT_RANGES, new String[]{"bytes"});
        String rangeStr = request.getHeader("Range");
        if (response.contentType() == null) {
            ScxMediaType contentType = StaticHelper.getMediaTypeByFile(path);
            response.contentType(contentType);
        }
        if (rangeStr == null) {
            response.send(path);
            return;
        }
        List<Range> ranges = Range.parseRange(rangeStr);
        if (ranges.size() == 1) {
            Range range = ranges.get(0);
            long start = range.getStart();
            long end = range.getEnd(fileLength);
            long length = end - start + 1L;
            response.status(HttpStatus.PARTIAL_CONTENT);
            response.setHeader(HttpFieldName.CONTENT_RANGE, "bytes " + start + "-" + end + "/" + fileLength);
            response.contentLength(length);
            response.send(path, start, length);
        } else {
            response.send(path);
        }
    }

    public static ScxMediaType getMediaTypeByFile(Path path) {
        FileFormat fileFormat = FileFormat.findByFileName(path.getFileName().toString());
        if (fileFormat == null) {
            fileFormat = FileFormat.BIN;
        }
        MediaType mediaType = fileFormat.mediaType();
        ScxMediaTypeWritable contentType = ScxMediaType.of(mediaType);
        if (mediaType == MediaType.TEXT_PLAIN || mediaType == MediaType.TEXT_HTML || mediaType == MediaType.APPLICATION_XML || mediaType == MediaType.APPLICATION_JSON) {
            contentType.charset(StandardCharsets.UTF_8);
        }
        return contentType;
    }
}

