/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.headers.accept;

import cool.scx.http.headers.accept.AcceptWritable;
import cool.scx.http.headers.accept.MediaRange;
import cool.scx.http.media_type.ScxMediaType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AcceptImpl
implements AcceptWritable {
    private final List<MediaRange> mediaRanges;

    public AcceptImpl() {
        this.mediaRanges = new ArrayList<MediaRange>();
    }

    public AcceptImpl(List<MediaRange> sorted) {
        this.mediaRanges = sorted;
    }

    @Override
    public long size() {
        return this.mediaRanges.size();
    }

    @Override
    public boolean isAcceptable(ScxMediaType mediaType) {
        for (MediaRange range : this.mediaRanges) {
            if (!range.matches(mediaType)) continue;
            return true;
        }
        return false;
    }

    @Override
    @SafeVarargs
    public final <T extends ScxMediaType> T negotiate(T ... serverSupportedTypes) {
        for (MediaRange range : this.mediaRanges) {
            for (T supportedType : serverSupportedTypes) {
                if (!range.matches((ScxMediaType)supportedType)) continue;
                return supportedType;
            }
        }
        return null;
    }

    @Override
    public boolean contains(ScxMediaType mediaType) {
        for (MediaRange range : this.mediaRanges) {
            if (!range.exactMatch(mediaType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<MediaRange> iterator() {
        return this.mediaRanges.iterator();
    }

    @Override
    public AcceptWritable add(MediaRange mediaRange) {
        this.mediaRanges.add(mediaRange);
        return this;
    }

    @Override
    public AcceptWritable remove(MediaRange mediaRange) {
        this.mediaRanges.remove(mediaRange);
        return this;
    }
}

