/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.path;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media_type.FileFormat;
import cool.scx.http.media_type.MediaType;
import cool.scx.io.IOHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;

public class PathWriter
implements MediaWriter {
    private final Path path;
    private final long fileRealSize;
    private final long offset;
    private final long length;

    public PathWriter(Path path) {
        this.path = path;
        this.fileRealSize = IOHelper.getFileSize((Path)path);
        this.offset = 0L;
        this.length = this.fileRealSize;
    }

    public PathWriter(Path path, long offset, long length) {
        this.path = path;
        this.fileRealSize = IOHelper.getFileSize((Path)path);
        this.offset = offset;
        this.length = length;
    }

    @Override
    public long beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        if (responseHeaders.contentType() == null) {
            FileFormat fileFormat = FileFormat.findByFileName(this.path.toString());
            if (fileFormat == null) {
                responseHeaders.contentType(MediaType.APPLICATION_OCTET_STREAM);
            } else {
                responseHeaders.contentType(fileFormat.mediaType());
            }
        }
        return this.length;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        try (OutputStream outputStream2 = outputStream;){
            boolean writeFullFile;
            boolean bl = writeFullFile = this.offset == 0L && this.length == this.fileRealSize;
            if (writeFullFile) {
                IOHelper.writeFileToOut((Path)this.path, (OutputStream)outputStream);
            } else {
                IOHelper.writeFileToOut((Path)this.path, (OutputStream)outputStream, (long)this.offset, (long)this.length);
            }
        }
    }
}

