/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.string;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media_type.ScxMediaType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class StringReader
implements MediaReader<String> {
    public static final StringReader STRING_READER = new StringReader();
    private final Charset charset;

    public StringReader(Charset charset) {
        this.charset = charset;
    }

    private StringReader() {
        this.charset = null;
    }

    public static Charset getContentTypeCharsetOrUTF8(ScxHttpHeaders headers) {
        Charset charset;
        ScxMediaType contentType = headers.contentType();
        if (contentType != null && (charset = contentType.charset()) != null) {
            return charset;
        }
        return StandardCharsets.UTF_8;
    }

    @Override
    public String read(InputStream inputStream, ScxHttpHeaders headers) throws IOException {
        Charset c = this.charset != null ? this.charset : StringReader.getContentTypeCharsetOrUTF8(headers);
        try (InputStream inputStream2 = inputStream;){
            byte[] bytes = inputStream.readAllBytes();
            String string = new String(bytes, c);
            return string;
        }
    }
}

