/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.status;

import cool.scx.http.status.HttpStatus;
import cool.scx.http.status.ScxHttpStatus;
import java.util.EnumMap;

public final class ScxHttpStatusHelper {
    private static final EnumMap<HttpStatus, String> MAP = ScxHttpStatusHelper.initMap();

    private static EnumMap<HttpStatus, String> initMap() {
        EnumMap<HttpStatus, String> m = new EnumMap<HttpStatus, String>(HttpStatus.class);
        m.put(HttpStatus.CONTINUE, "Continue");
        m.put(HttpStatus.SWITCHING_PROTOCOLS, "Switching Protocols");
        m.put(HttpStatus.OK, "OK");
        m.put(HttpStatus.CREATED, "Created");
        m.put(HttpStatus.ACCEPTED, "Accepted");
        m.put(HttpStatus.NON_AUTHORITATIVE_INFORMATION, "Non-Authoritative Information");
        m.put(HttpStatus.NO_CONTENT, "No Content");
        m.put(HttpStatus.RESET_CONTENT, "Reset Content");
        m.put(HttpStatus.PARTIAL_CONTENT, "Partial Content");
        m.put(HttpStatus.MULTIPLE_CHOICES, "Multiple Choices");
        m.put(HttpStatus.MOVED_PERMANENTLY, "Moved Permanently");
        m.put(HttpStatus.FOUND, "Found");
        m.put(HttpStatus.SEE_OTHER, "See Other");
        m.put(HttpStatus.NOT_MODIFIED, "Not Modified");
        m.put(HttpStatus.TEMPORARY_REDIRECT, "Temporary Redirect");
        m.put(HttpStatus.PERMANENT_REDIRECT, "Permanent Redirect");
        m.put(HttpStatus.BAD_REQUEST, "Bad Request");
        m.put(HttpStatus.UNAUTHORIZED, "Unauthorized");
        m.put(HttpStatus.PAYMENT_REQUIRED, "Payment Required");
        m.put(HttpStatus.FORBIDDEN, "Forbidden");
        m.put(HttpStatus.NOT_FOUND, "Not Found");
        m.put(HttpStatus.METHOD_NOT_ALLOWED, "Method Not Allowed");
        m.put(HttpStatus.NOT_ACCEPTABLE, "Not Acceptable");
        m.put(HttpStatus.PROXY_AUTHENTICATION_REQUIRED, "Proxy Authentication Required");
        m.put(HttpStatus.REQUEST_TIMEOUT, "Request Timeout");
        m.put(HttpStatus.CONFLICT, "Conflict");
        m.put(HttpStatus.GONE, "Gone");
        m.put(HttpStatus.LENGTH_REQUIRED, "Length Required");
        m.put(HttpStatus.PRECONDITION_FAILED, "Precondition Failed");
        m.put(HttpStatus.CONTENT_TOO_LARGE, "Content Too Large");
        m.put(HttpStatus.URI_TOO_LONG, "URI Too Long");
        m.put(HttpStatus.UNSUPPORTED_MEDIA_TYPE, "Unsupported Media Type");
        m.put(HttpStatus.RANGE_NOT_SATISFIABLE, "Range Not Satisfiable");
        m.put(HttpStatus.EXPECTATION_FAILED, "Expectation Failed");
        m.put(HttpStatus.MISDIRECTED_REQUEST, "Misdirected Request");
        m.put(HttpStatus.UNPROCESSABLE_CONTENT, "Unprocessable Content");
        m.put(HttpStatus.UPGRADE_REQUIRED, "Upgrade Required");
        m.put(HttpStatus.TOO_MANY_REQUESTS, "Too Many Requests");
        m.put(HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE, "Request Header Fields Too Large");
        m.put(HttpStatus.INTERNAL_SERVER_ERROR, "Internal Server Error");
        m.put(HttpStatus.NOT_IMPLEMENTED, "Not Implemented");
        m.put(HttpStatus.BAD_GATEWAY, "Bad Gateway");
        m.put(HttpStatus.SERVICE_UNAVAILABLE, "Service Unavailable");
        m.put(HttpStatus.GATEWAY_TIMEOUT, "Gateway Timeout");
        m.put(HttpStatus.HTTP_VERSION_NOT_SUPPORTED, "HTTP Version Not Supported");
        return m;
    }

    public static String getReasonPhrase(HttpStatus status) {
        return MAP.get(status);
    }

    public static String getReasonPhrase(ScxHttpStatus status, String defaultReasonPhrase) {
        String string;
        if (status instanceof HttpStatus) {
            HttpStatus s = (HttpStatus)status;
            string = ScxHttpStatusHelper.getReasonPhrase(s);
        } else {
            string = defaultReasonPhrase;
        }
        return string;
    }
}

