/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.headers;

import cool.scx.http.exception.BadRequestException;
import cool.scx.http.headers.HttpFieldName;
import cool.scx.http.headers.ScxHttpHeaderName;
import cool.scx.http.headers.ScxHttpHeadersHelper;
import cool.scx.http.headers.ScxHttpHeadersImpl;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.headers.accept.Accept;
import cool.scx.http.headers.accept.IllegalMediaRangeException;
import cool.scx.http.headers.content_disposition.ContentDisposition;
import cool.scx.http.headers.content_encoding.ScxContentEncoding;
import cool.scx.http.headers.cookie.Cookie;
import cool.scx.http.headers.cookie.Cookies;
import cool.scx.http.media_type.IllegalMediaTypeException;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.http.parameters.Parameters;
import java.util.List;

public interface ScxHttpHeaders
extends Parameters<ScxHttpHeaderName, String> {
    public static ScxHttpHeadersWritable of() {
        return new ScxHttpHeadersImpl();
    }

    public static ScxHttpHeadersWritable of(ScxHttpHeaders oldHeaders) {
        return new ScxHttpHeadersImpl(oldHeaders);
    }

    public static ScxHttpHeadersWritable of(String headersStr) {
        return ScxHttpHeadersHelper.parseHeaders(new ScxHttpHeadersImpl(), headersStr, false);
    }

    public static ScxHttpHeadersWritable ofStrict(String headersStr) {
        return ScxHttpHeadersHelper.parseHeaders(new ScxHttpHeadersImpl(), headersStr, true);
    }

    @Override
    default public String get(String name) {
        return (String)this.get(ScxHttpHeaderName.of(name));
    }

    @Override
    default public List<String> getAll(String name) {
        return this.getAll(ScxHttpHeaderName.of(name));
    }

    @Override
    default public boolean contains(String name) {
        return this.contains(ScxHttpHeaderName.of(name));
    }

    default public Cookies cookies() {
        String c = (String)this.get(HttpFieldName.COOKIE);
        return c != null ? Cookies.of(c) : Cookies.of();
    }

    default public Cookies setCookies() {
        List<String> c = this.getAll(HttpFieldName.SET_COOKIE);
        return !c.isEmpty() ? Cookies.ofSetCookie(c) : Cookies.of();
    }

    default public ScxMediaType contentType() {
        String v = (String)this.get(HttpFieldName.CONTENT_TYPE);
        try {
            return v != null ? ScxMediaType.of(v) : null;
        }
        catch (IllegalMediaTypeException e) {
            throw new BadRequestException("Invalid Content-Type: " + v, (Throwable)e);
        }
    }

    default public ContentDisposition contentDisposition() {
        String c = (String)this.get(HttpFieldName.CONTENT_DISPOSITION);
        return c != null ? ContentDisposition.of(c) : null;
    }

    default public Long contentLength() {
        String c = (String)this.get(HttpFieldName.CONTENT_LENGTH);
        try {
            return c != null ? Long.valueOf(Long.parseLong(c)) : null;
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("Invalid Content-Length: " + c, (Throwable)e);
        }
    }

    default public ScxContentEncoding contentEncoding() {
        String c = (String)this.get(HttpFieldName.CONTENT_ENCODING);
        return c != null ? ScxContentEncoding.of(c) : null;
    }

    default public Cookie getCookie(String name) {
        return this.cookies().get(name);
    }

    default public Cookie getSetCookie(String name) {
        return this.setCookies().get(name);
    }

    default public Accept accept() {
        String c = (String)this.get(HttpFieldName.ACCEPT);
        try {
            return c != null ? Accept.of(c) : null;
        }
        catch (IllegalMediaRangeException e) {
            throw new BadRequestException("Invalid Accept: " + c, (Throwable)e);
        }
    }

    default public String encode() {
        return ScxHttpHeadersHelper.encodeHeaders(this);
    }
}

