/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.routing;

import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.routing.Route;
import cool.scx.http.routing.Router;
import cool.scx.http.routing.RoutingContextImpl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class RouterImpl
implements Router {
    private static final Comparator<Route> ROUTE_COMPARATOR = (o1, o2) -> {
        int compare = Integer.compare(o1.order(), o2.order());
        if (compare == 0) {
            if (o1.equals(o2)) {
                return 0;
            }
            return 1;
        }
        return compare;
    };
    final TreeSet<Route> routes = new TreeSet<Route>(ROUTE_COMPARATOR);

    @Override
    public RouterImpl addRoute(Route route) {
        this.routes.add(route);
        return this;
    }

    @Override
    public List<Route> getRoutes() {
        return new ArrayList<Route>(this.routes);
    }

    @Override
    public void accept(ScxHttpServerRequest scxHttpRequest) {
        new RoutingContextImpl(this, scxHttpRequest).next();
    }
}

