/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.object;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.common.util.ObjectUtils;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.tree.TreeHelper;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class ObjectWriter
implements MediaWriter {
    private final Object object;
    private byte[] data;

    public ObjectWriter(Object object) {
        this.object = object;
        this.data = null;
    }

    @Override
    public long beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        block4: {
            ScxMediaType contentType = TreeHelper.trySetContentType(responseHeaders, requestHeaders);
            try {
                if (MediaType.APPLICATION_JSON.equalsIgnoreParams(contentType)) {
                    this.data = ObjectUtils.toJson((Object)this.object).getBytes(StandardCharsets.UTF_8);
                    break block4;
                }
                if (MediaType.APPLICATION_XML.equalsIgnoreParams(contentType)) {
                    this.data = ObjectUtils.toXml((Object)this.object).getBytes(StandardCharsets.UTF_8);
                    break block4;
                }
                throw new IllegalArgumentException("Unsupported media type: " + String.valueOf(contentType));
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.data.length;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        try (OutputStream outputStream2 = outputStream;){
            outputStream.write(this.data);
        }
    }
}

