/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.tree;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.http.exception.BadRequestException;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media.string.StringReader;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import java.io.IOException;
import java.io.InputStream;

public class TreeReader
implements MediaReader<JsonNode> {
    public static final TreeReader TREE_READER = new TreeReader();

    private TreeReader() {
    }

    @Override
    public JsonNode read(InputStream inputStream, ScxHttpHeaders requestHeaders) throws IOException {
        String str = StringReader.STRING_READER.read(inputStream, requestHeaders);
        ScxMediaType contentType = requestHeaders.contentType();
        if (MediaType.APPLICATION_JSON.equalsIgnoreParams(contentType)) {
            try {
                return ObjectUtils.jsonMapper().readTree(str);
            }
            catch (JsonProcessingException e) {
                throw new BadRequestException("JSON \u683c\u5f0f\u4e0d\u6b63\u786e !!!", (Throwable)e);
            }
        }
        if (MediaType.APPLICATION_XML.equalsIgnoreParams(contentType)) {
            try {
                return ObjectUtils.xmlMapper().readTree(str);
            }
            catch (JsonProcessingException e) {
                throw new BadRequestException("XML \u683c\u5f0f\u4e0d\u6b63\u786e !!!", (Throwable)e);
            }
        }
        try {
            return ObjectUtils.jsonMapper().readTree(str);
        }
        catch (Exception exception) {
            try {
                return ObjectUtils.xmlMapper().readTree(str);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u8f6c\u6362\u4e3a JsonNode !!! : " + str);
            }
        }
    }
}

