/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.uri;

import cool.scx.http.parameters.Parameters;
import cool.scx.http.uri.ScxURIHelper;
import cool.scx.http.uri.ScxURIImpl;
import cool.scx.http.uri.ScxURIWritable;
import cool.scx.http.uri.URIEncoder;
import java.net.URI;

public interface ScxURI {
    public static ScxURIWritable of() {
        return new ScxURIImpl();
    }

    public static ScxURIWritable of(String rawStr) {
        return ScxURI.ofEncoded(URIEncoder.encodeURI(rawStr));
    }

    public static ScxURIWritable ofEncoded(String encodedStr) {
        return ScxURI.of(URI.create(encodedStr));
    }

    public static ScxURIWritable of(URI u) {
        return new ScxURIImpl().scheme(u.getScheme()).host(u.getHost()).port(u.getPort() == -1 ? null : Integer.valueOf(u.getPort())).path(u.getPath()).query(u.getQuery()).fragment(u.getFragment());
    }

    public static ScxURIWritable of(ScxURI u) {
        return new ScxURIImpl().scheme(u.scheme()).host(u.host()).port(u.port()).path(u.path()).query(u.query()).fragment(u.fragment());
    }

    public static ScxURI ofAuthority(String authority) {
        return ScxURIHelper.decodeAuthority(authority);
    }

    public String scheme();

    public String host();

    public Integer port();

    public String path();

    public Parameters<String, String> query();

    public String fragment();

    default public String getQuery(String name) {
        return this.query().get(name);
    }

    default public String encode() {
        return this.encode(false);
    }

    default public String encode(boolean uriEncoding) {
        return ScxURIHelper.encodeScxURI(this, uriEncoding);
    }

    default public URI toURI() {
        return URI.create(this.encode(true));
    }
}

