/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.headers;

import cool.scx.http.headers.HttpFieldName;
import cool.scx.http.headers.ScxHttpHeaderName;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.content_disposition.ContentDisposition;
import cool.scx.http.headers.content_encoding.ScxContentEncoding;
import cool.scx.http.headers.cookie.Cookie;
import cool.scx.http.headers.cookie.Cookies;
import cool.scx.http.headers.cookie.CookiesWritable;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.http.parameters.ParametersWritable;

public interface ScxHttpHeadersWritable
extends ScxHttpHeaders,
ParametersWritable<ScxHttpHeaderName, String> {
    public ScxHttpHeadersWritable set(ScxHttpHeaderName var1, String ... var2);

    public ScxHttpHeadersWritable add(ScxHttpHeaderName var1, String ... var2);

    public ScxHttpHeadersWritable remove(ScxHttpHeaderName var1);

    public ScxHttpHeadersWritable clear();

    default public ScxHttpHeadersWritable set(String name, String ... value) {
        return this.set(ScxHttpHeaderName.of(name), value);
    }

    default public ScxHttpHeadersWritable add(String name, String ... value) {
        return this.add(ScxHttpHeaderName.of(name), value);
    }

    default public ScxHttpHeadersWritable remove(String name) {
        return this.remove(ScxHttpHeaderName.of(name));
    }

    default public ScxHttpHeadersWritable cookies(Cookies cookies) {
        return this.set(HttpFieldName.COOKIE, new String[]{cookies.encodeCookie()});
    }

    default public ScxHttpHeadersWritable setCookies(Cookies cookies) {
        return this.set(HttpFieldName.SET_COOKIE, cookies.encodeSetCookie());
    }

    default public ScxHttpHeadersWritable contentType(ScxMediaType mediaType) {
        return this.set(HttpFieldName.CONTENT_TYPE, new String[]{mediaType.encode()});
    }

    default public ScxHttpHeadersWritable contentDisposition(ContentDisposition contentDisposition) {
        return this.set(HttpFieldName.CONTENT_DISPOSITION, new String[]{contentDisposition.encode()});
    }

    default public ScxHttpHeadersWritable addCookie(Cookie ... cookie) {
        CookiesWritable newCookies = (CookiesWritable)this.cookies();
        for (Cookie c : cookie) {
            newCookies.add(c);
        }
        return this.cookies(newCookies);
    }

    default public ScxHttpHeadersWritable removeCookie(String name) {
        CookiesWritable newCookies = (CookiesWritable)this.cookies();
        newCookies.remove(name);
        return this.cookies(newCookies);
    }

    default public ScxHttpHeadersWritable addSetCookie(Cookie ... cookie) {
        CookiesWritable newSetCookies = (CookiesWritable)this.setCookies();
        for (Cookie c : cookie) {
            newSetCookies.add(c);
        }
        return this.setCookies(newSetCookies);
    }

    default public ScxHttpHeadersWritable removeSetCookie(String name) {
        CookiesWritable newSetCookies = (CookiesWritable)this.setCookies();
        newSetCookies.remove(name);
        return this.cookies(newSetCookies);
    }

    default public ScxHttpHeadersWritable contentLength(long contentLength) {
        return this.set(HttpFieldName.CONTENT_LENGTH, new String[]{String.valueOf(contentLength)});
    }

    default public ScxHttpHeadersWritable contentEncoding(ScxContentEncoding contentEncoding) {
        return this.set(HttpFieldName.CONTENT_ENCODING, new String[]{contentEncoding.value()});
    }
}

