/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.headers.content_encoding;

import cool.scx.http.headers.content_encoding.ScxContentEncoding;

public enum ContentEncoding implements ScxContentEncoding
{
    GZIP("gzip");

    private final String value;

    private ContentEncoding(String value) {
        this.value = value;
    }

    public static ContentEncoding of(String v) {
        ContentEncoding h = ContentEncoding.find(v);
        if (h == null) {
            throw new IllegalArgumentException("Unknown content-encoding: " + v);
        }
        return h;
    }

    public static ContentEncoding find(String v) {
        String lv;
        return switch (lv = v.toLowerCase()) {
            case "gzip" -> GZIP;
            default -> null;
        };
    }

    @Override
    public String value() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

