/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.headers.cookie;

import cool.scx.http.headers.cookie.CookieHelper;
import cool.scx.http.headers.cookie.CookieSameSite;
import cool.scx.http.headers.cookie.CookieWritable;

class CookieImpl
implements CookieWritable {
    private final String name;
    private final String value;
    private String domain;
    private String path;
    private Long maxAge;
    private boolean secure;
    private boolean httpOnly;
    private CookieSameSite sameSite;

    public CookieImpl(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public CookieWritable domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public CookieWritable path(String path) {
        this.path = path;
        return this;
    }

    @Override
    public CookieWritable maxAge(Long maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    @Override
    public CookieWritable secure(boolean secure) {
        this.secure = secure;
        return this;
    }

    @Override
    public CookieWritable httpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    @Override
    public CookieWritable sameSite(CookieSameSite sameSite) {
        this.sameSite = sameSite;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String domain() {
        return this.domain;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public Long maxAge() {
        return this.maxAge;
    }

    @Override
    public boolean secure() {
        return this.secure;
    }

    @Override
    public boolean httpOnly() {
        return this.httpOnly;
    }

    @Override
    public CookieSameSite sameSite() {
        return this.sameSite;
    }

    @Override
    public String encode() {
        return CookieHelper.encodeCookie(this);
    }

    public String toString() {
        return this.encode();
    }
}

