/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.multi_part;

import cool.scx.http.body.BodyAlreadyConsumedException;
import cool.scx.http.body.BodyReadException;
import cool.scx.http.body.ScxHttpBody;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.content_disposition.ContentDisposition;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media.multi_part.MultiPartPartImpl;
import cool.scx.http.media.multi_part.MultiPartPartWritable;
import cool.scx.http.media_type.FileFormat;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.io.IOHelper;
import cool.scx.io.io_stream.StreamClosedException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.Supplier;

public interface MultiPartPart
extends ScxHttpBody {
    public static MultiPartPartWritable of() {
        return new MultiPartPartImpl();
    }

    public static MultiPartPartWritable of(String name, String value) {
        return new MultiPartPartImpl().name(name).body(value);
    }

    public static MultiPartPartWritable of(String name, byte[] value) {
        return new MultiPartPartImpl().name(name).body(value);
    }

    public static MultiPartPartWritable of(String name, Path value) {
        long fileSize = IOHelper.getFileSize((Path)value);
        FileFormat fileFormat = FileFormat.findByFileName(value.toString());
        MediaType contentType = fileFormat == null ? MediaType.APPLICATION_OCTET_STREAM : fileFormat.mediaType();
        String filename = value.getFileName().toString();
        return new MultiPartPartImpl().name(name).body(value).size(fileSize).filename(filename).contentType(contentType);
    }

    public ScxHttpHeaders headers();

    public Supplier<InputStream> body();

    @Override
    default public InputStream inputStream() {
        return this.body().get();
    }

    @Override
    default public <T> T as(MediaReader<T> t) throws BodyAlreadyConsumedException, BodyReadException {
        try {
            return t.read(this.inputStream(), this.headers());
        }
        catch (IOException e) {
            throw new BodyReadException(e);
        }
        catch (StreamClosedException e) {
            throw new BodyAlreadyConsumedException();
        }
    }

    default public ScxMediaType contentType() {
        return this.headers().contentType();
    }

    default public ContentDisposition contentDisposition() {
        return this.headers().contentDisposition();
    }

    default public String name() {
        ContentDisposition contentDisposition = this.contentDisposition();
        return contentDisposition != null ? contentDisposition.name() : null;
    }

    default public String filename() {
        ContentDisposition contentDisposition = this.contentDisposition();
        return contentDisposition != null ? contentDisposition.filename() : null;
    }

    default public Long size() {
        ContentDisposition contentDisposition = this.contentDisposition();
        return contentDisposition != null ? contentDisposition.size() : null;
    }
}

