/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.event_stream;

import cool.scx.bytes.ByteReader;
import cool.scx.http.media.event_stream.EventStreamHelper;
import cool.scx.http.media.event_stream.SseEvent;
import cool.scx.http.media.event_stream.SseEventWritable;
import cool.scx.io.IOHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class ClientEventStream {
    private final ByteReader dataReader;
    private final Charset charset;

    public ClientEventStream(InputStream in, Charset charset) {
        this.dataReader = IOHelper.inputStreamToByteReader((InputStream)in);
        this.charset = charset;
    }

    public SseEvent readEvent() throws IOException {
        SseEventWritable event = SseEvent.of();
        byte[] bytes;
        String line;
        while (!(line = new String(bytes = this.dataReader.readUntil(EventStreamHelper.LF_BYTES), this.charset)).isEmpty()) {
            if (line.startsWith("event: ")) {
                event.event(line.substring(7).trim());
                continue;
            }
            if (line.startsWith("data: ")) {
                event.data(line.substring(6).trim());
                continue;
            }
            if (line.startsWith("id: ")) {
                event.id(line.substring(4).trim());
                continue;
            }
            if (line.startsWith("retry: ")) {
                try {
                    event.retry(Long.parseLong(line.substring(7).trim()));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!line.startsWith(": ")) continue;
            event.comment(line.substring(2).trim());
        }
        return event;
    }
}

