/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.event_stream.event;

import cool.scx.http.media.event_stream.ClientEventStream;
import cool.scx.http.media.event_stream.SseEvent;
import java.util.function.Consumer;

public class EventClientEventStream {
    private final ClientEventStream eventStream;
    private Consumer<SseEvent> eventHandler;
    private boolean running;

    public EventClientEventStream(ClientEventStream eventStream) {
        this.eventStream = eventStream;
        this.running = false;
    }

    public static EventClientEventStream of(ClientEventStream eventStream) {
        return new EventClientEventStream(eventStream);
    }

    public EventClientEventStream onEvent(Consumer<SseEvent> eventHandler) {
        this.eventHandler = eventHandler;
        return this;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        while (this.running) {
            try {
                SseEvent event = this.eventStream.readEvent();
                this._callEventHandler(event);
            }
            catch (Exception e) {
                break;
            }
        }
    }

    private void _callEventHandler(SseEvent sseEvent) {
        if (this.eventHandler != null) {
            this.eventHandler.accept(sseEvent);
        }
    }

    public void stop() {
        this.running = false;
    }
}

