/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.multi_part;

import cool.scx.bytes.ByteReader;
import cool.scx.bytes.IByteReader;
import cool.scx.bytes.supplier.BoundaryByteSupplier;
import cool.scx.bytes.supplier.ByteSupplier;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartPart;
import cool.scx.http.media.multi_part.MultiPartPartImpl;
import cool.scx.io.IOHelper;
import cool.scx.io.io_stream.ByteReaderInputStream;
import cool.scx.io.io_stream.StreamClosedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MultiPartStream
implements MultiPart,
Iterator<MultiPartPart>,
AutoCloseable {
    private static final byte[] CRLF_CRLF_BYTES = "\r\n\r\n".getBytes();
    private final String boundary;
    private final byte[] boundaryBytes;
    private final byte[] boundaryStartBytes;
    private final ByteReader linkedByteReader;
    private MultiPartPart lastPart;

    public MultiPartStream(InputStream inputStream, String boundary) {
        this.boundary = boundary;
        this.boundaryBytes = ("--" + boundary).getBytes();
        this.boundaryStartBytes = ("\r\n--" + boundary).getBytes();
        this.linkedByteReader = IOHelper.inputStreamToByteReader((InputStream)inputStream);
        this.lastPart = null;
    }

    public static void consumeInputStream(InputStream inputStream) {
        try (InputStream inputStream2 = inputStream;){
            inputStream.transferTo(OutputStream.nullOutputStream());
        }
        catch (StreamClosedException | IOException throwable) {
            // empty catch block
        }
    }

    public ScxHttpHeadersWritable readHeaders() {
        byte[] headersBytes = this.linkedByteReader.readUntil(CRLF_CRLF_BYTES);
        String headersStr = new String(headersBytes);
        return ScxHttpHeaders.ofStrict(headersStr);
    }

    public InputStream readContent() {
        return new ByteReaderInputStream(new ByteReader((ByteSupplier)new BoundaryByteSupplier((IByteReader)this.linkedByteReader, this.boundaryStartBytes)));
    }

    @Override
    public String boundary() {
        return this.boundary;
    }

    @Override
    public Iterator<MultiPartPart> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        byte[] peek;
        if (this.lastPart != null) {
            MultiPartStream.consumeInputStream(this.lastPart.inputStream());
            this.linkedByteReader.skip(2L);
            this.lastPart = null;
        }
        if ((peek = this.linkedByteReader.peek(this.boundaryBytes.length + 2)).length != this.boundaryBytes.length + 2) {
            throw new RuntimeException("Malformed multipart: boundary peek too short");
        }
        for (int i = 0; i < this.boundaryBytes.length; ++i) {
            if (peek[i] == this.boundaryBytes[i]) continue;
            throw new RuntimeException("Malformed multipart: boundary not matched");
        }
        byte a = peek[peek.length - 2];
        byte b = peek[peek.length - 1];
        if (a == 45 && b == 45) {
            return false;
        }
        if (a == 13 && b == 10) {
            return true;
        }
        throw new RuntimeException("Malformed multipart: invalid boundary ending");
    }

    @Override
    public MultiPartPart next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more parts available.");
        }
        this.linkedByteReader.skip((long)(this.boundaryBytes.length + 2));
        MultiPartPartImpl part = new MultiPartPartImpl();
        ScxHttpHeadersWritable headers = this.readHeaders();
        part.headers(headers);
        InputStream content = this.readContent();
        part.body(content);
        this.lastPart = part;
        return part;
    }

    @Override
    public void close() throws Exception {
    }
}

