/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.tree;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.tree.TreeHelper;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class TreeWriter
implements MediaWriter {
    private final JsonNode jsonNode;
    private byte[] data;

    public TreeWriter(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
        this.data = null;
    }

    @Override
    public long beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        block4: {
            ScxMediaType contentType = TreeHelper.trySetContentType(responseHeaders, requestHeaders);
            try {
                if (MediaType.APPLICATION_JSON.equalsIgnoreParams(contentType)) {
                    this.data = ObjectUtils.jsonMapper().writeValueAsString((Object)this.jsonNode).getBytes(StandardCharsets.UTF_8);
                    break block4;
                }
                if (MediaType.APPLICATION_XML.equalsIgnoreParams(contentType)) {
                    this.data = ObjectUtils.xmlMapper().writeValueAsString((Object)this.jsonNode).getBytes(StandardCharsets.UTF_8);
                    break block4;
                }
                throw new IllegalArgumentException("Unsupported media type: " + String.valueOf(contentType));
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.data.length;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        try (OutputStream outputStream2 = outputStream;){
            outputStream.write(this.data);
        }
    }
}

