/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.tree;

import cool.scx.http.exception.BadRequestException;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media.string.StringReader;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.object.ScxObject;
import cool.scx.object.node.Node;
import cool.scx.object.parser.NodeParseException;
import java.io.IOException;
import java.io.InputStream;

public class TreeReader
implements MediaReader<Node> {
    public static final TreeReader TREE_READER = new TreeReader();

    private TreeReader() {
    }

    @Override
    public Node read(InputStream inputStream, ScxHttpHeaders requestHeaders) throws IOException {
        String str = StringReader.STRING_READER.read(inputStream, requestHeaders);
        ScxMediaType contentType = requestHeaders.contentType();
        if (MediaType.APPLICATION_JSON.equalsIgnoreParams(contentType)) {
            try {
                return ScxObject.fromJson((String)str);
            }
            catch (NodeParseException e) {
                throw new BadRequestException("JSON \u683c\u5f0f\u4e0d\u6b63\u786e !!!", (Throwable)e);
            }
        }
        if (MediaType.APPLICATION_XML.equalsIgnoreParams(contentType)) {
            try {
                return ScxObject.fromXml((String)str);
            }
            catch (NodeParseException e) {
                throw new BadRequestException("XML \u683c\u5f0f\u4e0d\u6b63\u786e !!!", (Throwable)e);
            }
        }
        try {
            return ScxObject.fromJson((String)str);
        }
        catch (NodeParseException exception) {
            try {
                return ScxObject.fromXml((String)str);
            }
            catch (NodeParseException e) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u8f6c\u6362\u4e3a JsonNode !!! : " + str);
            }
        }
    }
}

