/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.tree;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.tree.TreeHelper;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.object.ScxObject;
import cool.scx.object.node.Node;
import cool.scx.object.serializer.NodeSerializeException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class TreeWriter
implements MediaWriter {
    private final Node jsonNode;
    private byte[] data;

    public TreeWriter(Node jsonNode) {
        this.jsonNode = jsonNode;
        this.data = null;
    }

    @Override
    public long beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        block4: {
            ScxMediaType contentType = TreeHelper.trySetContentType(responseHeaders, requestHeaders);
            try {
                if (MediaType.APPLICATION_JSON.equalsIgnoreParams(contentType)) {
                    this.data = ScxObject.toJson((Node)this.jsonNode).getBytes(StandardCharsets.UTF_8);
                    break block4;
                }
                if (MediaType.APPLICATION_XML.equalsIgnoreParams(contentType)) {
                    this.data = ScxObject.toXml((Node)this.jsonNode).getBytes(StandardCharsets.UTF_8);
                    break block4;
                }
                throw new IllegalArgumentException("Unsupported media type: " + String.valueOf(contentType));
            }
            catch (NodeSerializeException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.data.length;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        try (OutputStream outputStream2 = outputStream;){
            outputStream.write(this.data);
        }
    }
}

