/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.sender;

import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.byte_array.ByteArrayWriter;
import cool.scx.http.media.empty.EmptyWriter;
import cool.scx.http.media.event_stream.ServerEventStream;
import cool.scx.http.media.event_stream.ServerEventStreamWriter;
import cool.scx.http.media.form_params.FormParams;
import cool.scx.http.media.form_params.FormParamsWriter;
import cool.scx.http.media.input_stream.InputStreamWriter;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartWriter;
import cool.scx.http.media.object.ObjectWriter;
import cool.scx.http.media.path.PathWriter;
import cool.scx.http.media.string.StringWriter;
import cool.scx.http.media.tree.TreeWriter;
import cool.scx.http.sender.BodyAlreadySentException;
import cool.scx.http.sender.GzipSender;
import cool.scx.http.sender.HttpSendException;
import cool.scx.object.node.Node;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;

public interface ScxHttpSender<T> {
    public T send(MediaWriter var1) throws BodyAlreadySentException, HttpSendException;

    default public T send() throws HttpSendException, BodyAlreadySentException {
        return this.send(EmptyWriter.EMPTY_WRITER);
    }

    default public T send(InputStream inputStream) throws BodyAlreadySentException, HttpSendException {
        return this.send(new InputStreamWriter(inputStream));
    }

    default public T send(byte[] bytes) throws BodyAlreadySentException, HttpSendException {
        return this.send(new ByteArrayWriter(bytes));
    }

    default public T send(String str) throws BodyAlreadySentException, HttpSendException {
        return this.send(new StringWriter(str));
    }

    default public T send(String str, Charset charset) throws BodyAlreadySentException, HttpSendException {
        return this.send(new StringWriter(str, charset));
    }

    default public T send(Path path) throws BodyAlreadySentException, HttpSendException {
        return this.send(new PathWriter(path));
    }

    default public T send(Path path, long offset, long length) throws BodyAlreadySentException, HttpSendException {
        return this.send(new PathWriter(path, offset, length));
    }

    default public T send(FormParams formParams) throws BodyAlreadySentException, HttpSendException {
        return this.send(new FormParamsWriter(formParams));
    }

    default public T send(MultiPart multiPart) throws BodyAlreadySentException, HttpSendException {
        return this.send(new MultiPartWriter(multiPart));
    }

    default public T send(Node node) throws BodyAlreadySentException, HttpSendException {
        return this.send(new TreeWriter(node));
    }

    default public T send(Object object) throws BodyAlreadySentException, HttpSendException {
        return this.send(new ObjectWriter(object));
    }

    default public ServerEventStream sendEventStream() throws BodyAlreadySentException, HttpSendException {
        ServerEventStreamWriter writer = new ServerEventStreamWriter();
        this.send(writer);
        return writer.eventStream();
    }

    default public ScxHttpSender<T> sendGzip() {
        return new GzipSender(this);
    }
}

