/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.body;

import cool.scx.http.body.BodyAlreadyConsumedException;
import cool.scx.http.body.BodyReadException;
import cool.scx.http.body.ScxHttpBody;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.media.MediaReader;
import cool.scx.io.ByteInput;
import cool.scx.io.DefaultByteInput;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;
import cool.scx.io.supplier.ByteSupplier;
import cool.scx.io.supplier.CacheByteSupplier;
import cool.scx.io.supplier.SpecialCloseByteSupplier;

public class CacheHttpBody
implements ScxHttpBody {
    private final ByteInput byteInput;
    private final ScxHttpHeaders headers;
    private final CacheByteSupplier cacheByteSupplier;
    private final SpecialCloseByteSupplier singleCloseByteSupplier;

    public CacheHttpBody(ByteInput byteInput, ScxHttpHeaders headers) {
        this.byteInput = byteInput;
        this.headers = headers;
        this.cacheByteSupplier = new CacheByteSupplier(byteInput);
        this.singleCloseByteSupplier = SpecialCloseByteSupplier.singleClose((ByteSupplier)this.cacheByteSupplier);
    }

    @Override
    public ByteInput byteInput() {
        this.cacheByteSupplier.reset();
        return new DefaultByteInput((ByteSupplier)this.singleCloseByteSupplier);
    }

    @Override
    public <T> T as(MediaReader<T> mediaReader) throws BodyAlreadyConsumedException, BodyReadException {
        try {
            return mediaReader.read(this.byteInput(), this.headers);
        }
        catch (ScxIOException e) {
            throw new BodyReadException(e);
        }
        catch (AlreadyClosedException e) {
            throw new BodyAlreadyConsumedException();
        }
    }

    @Override
    public CacheHttpBody asCacheBody() {
        return this;
    }
}

