/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.body;

import cool.scx.http.body.BodyAlreadyConsumedException;
import cool.scx.http.body.BodyReadException;
import cool.scx.http.body.ScxHttpBody;
import cool.scx.http.exception.UnsupportedMediaTypeException;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.content_encoding.ContentEncoding;
import cool.scx.http.headers.content_encoding.ScxContentEncoding;
import cool.scx.http.media.MediaReader;
import cool.scx.io.ByteInput;
import cool.scx.io.ScxIO;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;

public class GzipHttpBody
implements ScxHttpBody {
    private final ScxHttpHeaders headers;
    private final ByteInput gzipByteInput;

    public GzipHttpBody(ByteInput byteInput, ScxHttpHeaders headers) {
        this.headers = headers;
        this.gzipByteInput = GzipHttpBody.intGZIPByteInput(byteInput, this.headers.contentEncoding());
    }

    public static ByteInput intGZIPByteInput(ByteInput byteInput, ScxContentEncoding contentEncoding) {
        if (contentEncoding == null) {
            return byteInput;
        }
        if (contentEncoding == ContentEncoding.GZIP) {
            try {
                return ScxIO.gzipByteInput((ByteInput)byteInput);
            }
            catch (ScxIOException e) {
                throw new UnsupportedMediaTypeException(e.getCause());
            }
        }
        throw new UnsupportedMediaTypeException("Unsupported Content-Encoding: " + String.valueOf(contentEncoding));
    }

    @Override
    public ByteInput byteInput() {
        return this.gzipByteInput;
    }

    @Override
    public <T> T as(MediaReader<T> mediaReader) throws BodyReadException, BodyAlreadyConsumedException {
        try {
            return mediaReader.read(this.gzipByteInput, this.headers);
        }
        catch (ScxIOException e) {
            throw new BodyReadException(e);
        }
        catch (AlreadyClosedException e) {
            throw new BodyAlreadyConsumedException();
        }
    }

    @Override
    public GzipHttpBody asGzipBody() {
        return this;
    }
}

