/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.body;

import cool.scx.http.body.BodyAlreadyConsumedException;
import cool.scx.http.body.BodyReadException;
import cool.scx.http.body.CacheHttpBody;
import cool.scx.http.body.GzipHttpBody;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media.byte_array.ByteArrayMediaReader;
import cool.scx.http.media.event_stream.ClientEventStream;
import cool.scx.http.media.event_stream.ClientEventStreamMediaReader;
import cool.scx.http.media.file.FileMediaReader;
import cool.scx.http.media.form_params.FormParams;
import cool.scx.http.media.form_params.FormParamsMediaReader;
import cool.scx.http.media.multi_part.MultiPartStream;
import cool.scx.http.media.multi_part.MultiPartStreamMediaReader;
import cool.scx.http.media.node.NodeMediaReader;
import cool.scx.http.media.object.ObjectMediaReader;
import cool.scx.http.media.string.StringMediaReader;
import cool.scx.io.ByteInput;
import cool.scx.object.node.Node;
import cool.scx.reflect.TypeReference;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;

public interface ScxHttpBody {
    public ByteInput byteInput();

    public <T> T as(MediaReader<T> var1) throws BodyAlreadyConsumedException, BodyReadException;

    default public byte[] asBytes() throws BodyReadException, BodyAlreadyConsumedException {
        return this.as(ByteArrayMediaReader.BYTE_ARRAY_MEDIA_READER);
    }

    default public String asString() throws BodyReadException, BodyAlreadyConsumedException {
        return this.as(StringMediaReader.STRING_MEDIA_READER);
    }

    default public String asString(Charset charset) throws BodyReadException, BodyAlreadyConsumedException {
        return this.as(new StringMediaReader(charset));
    }

    default public File asFile(File file) throws BodyReadException, BodyAlreadyConsumedException {
        return this.as(new FileMediaReader(file, new OpenOption[0]));
    }

    default public FormParams asFormParams() throws BodyReadException, BodyAlreadyConsumedException {
        return this.as(FormParamsMediaReader.FORM_PARAMS_MEDIA_READER);
    }

    default public MultiPartStream asMultiPart() throws BodyReadException, BodyAlreadyConsumedException {
        return this.as(MultiPartStreamMediaReader.MULTI_PART_STREAM_MEDIA_READER);
    }

    default public Node asNode() throws BodyReadException, BodyAlreadyConsumedException {
        return this.as(NodeMediaReader.NODE_MEDIA_READER);
    }

    default public <T> T asObject(Class<T> c) throws BodyReadException, BodyAlreadyConsumedException {
        return this.as(new ObjectMediaReader<T>(c));
    }

    default public <T> T asObject(TypeReference<T> c) throws BodyReadException, BodyAlreadyConsumedException {
        return this.as(new ObjectMediaReader<T>(c));
    }

    default public ClientEventStream asEventStream() throws BodyReadException, BodyAlreadyConsumedException {
        return this.as(ClientEventStreamMediaReader.CLIENT_EVENT_STREAM_MEDIA_READER);
    }

    default public GzipHttpBody asGzipBody() throws BodyReadException, BodyAlreadyConsumedException {
        return this.as(GzipHttpBody::new);
    }

    default public CacheHttpBody asCacheBody() throws BodyReadException, BodyAlreadyConsumedException {
        return this.as(CacheHttpBody::new);
    }
}

