/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.error_handler;

import cool.scx.common.util.ExceptionUtils;
import cool.scx.http.ScxHttpServerRequest;
import cool.scx.http.ScxHttpServerResponse;
import cool.scx.http.error_handler.ErrorPhase;
import cool.scx.http.error_handler.ErrorPhaseHelper;
import cool.scx.http.error_handler.ScxHttpServerErrorHandler;
import cool.scx.http.exception.InternalServerErrorException;
import cool.scx.http.exception.ScxHttpException;
import cool.scx.http.headers.accept.Accept;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.http.status.ScxHttpStatus;
import cool.scx.http.status.ScxHttpStatusHelper;
import cool.scx.object.ScxObject;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class DefaultHttpServerErrorHandler
implements ScxHttpServerErrorHandler {
    public static final DefaultHttpServerErrorHandler DEFAULT_HTTP_SERVER_ERROR_HANDLER = new DefaultHttpServerErrorHandler(true);
    private static final System.Logger LOGGER = System.getLogger(DefaultHttpServerErrorHandler.class.getName());
    private static final String htmlTemplate = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <title>%s</title>\n</head>\n<body>\n    <h1>%s - %s</h1>\n    <hr>\n    <pre>%s</pre>\n</body>\n</html>\n";
    private final boolean useDevelopmentErrorPage;

    public DefaultHttpServerErrorHandler(boolean useDevelopmentErrorPage) {
        this.useDevelopmentErrorPage = useDevelopmentErrorPage;
    }

    public static void sendToClient(ScxHttpStatus status, String info, ScxHttpServerRequest request) {
        if (info == null) {
            info = "";
        }
        String reasonPhrase = ScxHttpStatusHelper.getReasonPhrase(status, "unknown");
        Accept accepts = null;
        try {
            accepts = request.headers().accept();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (accepts != null && accepts.contains(MediaType.TEXT_HTML)) {
            String htmlStr = String.format(htmlTemplate, reasonPhrase, status.code(), reasonPhrase, info);
            ((ScxHttpServerResponse)request.response().contentType(ScxMediaType.of(MediaType.TEXT_HTML).charset(StandardCharsets.UTF_8))).status(status).send(htmlStr);
        } else {
            String jsonStr = ScxObject.toJson(Map.of("status", status.code(), "title", reasonPhrase, "info", info));
            ((ScxHttpServerResponse)request.response().contentType(ScxMediaType.of(MediaType.APPLICATION_JSON).charset(StandardCharsets.UTF_8))).status(status).send(jsonStr);
        }
    }

    public void handleScxHttpException(ScxHttpException scxHttpException, ScxHttpServerRequest request) {
        String info = null;
        if (this.useDevelopmentErrorPage) {
            Throwable cause = scxHttpException.getCause();
            info = cause == null ? scxHttpException.getMessage() : ExceptionUtils.getStackTraceString((Throwable)cause);
        }
        DefaultHttpServerErrorHandler.sendToClient(scxHttpException.status(), info, request);
    }

    @Override
    public void accept(Throwable throwable, ScxHttpServerRequest request, ErrorPhase errorPhase) {
        if (throwable instanceof ScxHttpException) {
            ScxHttpException h = (ScxHttpException)throwable;
            this.handleScxHttpException(h, request);
        } else {
            LOGGER.log(System.Logger.Level.ERROR, ErrorPhaseHelper.getErrorPhaseStr(errorPhase) + " \u53d1\u751f\u5f02\u5e38 !!!", throwable);
            this.handleScxHttpException(new InternalServerErrorException(throwable), request);
        }
    }
}

