/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.byte_input;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.io.ByteInput;
import cool.scx.io.ByteOutput;
import cool.scx.io.NullByteInput;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;

public class ByteInputMediaWriter
implements MediaWriter {
    private final ByteInput byteInput;
    private final boolean autoClose;

    public ByteInputMediaWriter(ByteInput byteInput) {
        this(byteInput, true);
    }

    public ByteInputMediaWriter(ByteInput byteInput, boolean autoClose) {
        this.byteInput = byteInput;
        this.autoClose = autoClose;
    }

    @Override
    public long beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        if (this.byteInput instanceof NullByteInput) {
            return 0L;
        }
        return -1L;
    }

    @Override
    public void write(ByteOutput byteOutput) throws ScxIOException, AlreadyClosedException {
        try (ByteOutput byteOutput2 = byteOutput;){
            this.byteInput.transferToAll(byteOutput);
        }
        if (this.autoClose) {
            this.byteInput.close();
        }
    }
}

