/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.event_stream;

import cool.scx.http.media.event_stream.SseEvent;
import cool.scx.io.ByteOutput;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;
import java.nio.charset.StandardCharsets;

public class EventStreamHelper {
    public static final byte[] LF_BYTES = "\n".getBytes();

    public static void writeToOutputStream(SseEvent sseEvent, ByteOutput out) throws ScxIOException, AlreadyClosedException {
        String event = sseEvent.event();
        String data = sseEvent.data();
        String id = sseEvent.id();
        Long retry = sseEvent.retry();
        String comment = sseEvent.comment();
        StringBuilder sb = new StringBuilder();
        if (comment != null) {
            sb.append(": ").append(comment).append("\n");
        }
        if (event != null) {
            sb.append("event: ").append(event).append("\n");
        } else {
            sb.append("event: message\n");
        }
        if (data != null) {
            sb.append("data: ").append(data).append("\n");
        }
        if (id != null) {
            sb.append("id: ").append(id).append("\n");
        }
        if (retry != null) {
            sb.append("retry: ").append(retry).append("\n");
        }
        sb.append("\n");
        out.write(sb.toString().getBytes(StandardCharsets.UTF_8));
        out.flush();
    }
}

